* get quarterly regular data
use /Users/hunt/Desktop/Nervecenter/research/BPEA_recession/data/macro_q
* then merge on the monthly IFO business climate info which is monthly
* want to merge quarter to middle of the three months
recode quarter (1=2) (2=5) (3=8) (4=11),gen(month)
sort year month
merge year month using ~/research/BPEA_recession/data/IFO/ifo_m
tab _merge /* ifo has Q4 2010 and Q1 2011, leave */

* redefine "monthly year" so valid for all obs
drop year_m
gen year_m=year+(month-1)/12
sort year_m

* make value-added in manufacturing into index with 2000=100 like IFO vars
* IFO 2000 seems to be average of the whole year; for VA just do Q1 2000=100

* NO, think better to normalize all to 100 at start of boom ie Q2 2005
gen ho=vaman_r if year==2005&quarter==2
egen hoho=max(ho)
gen vaman_ri=(vaman_r/hoho)*100
label var vaman_ri "Real value-added manuf+mining Q2 2005=100"
drop ho hoho

*label var vaman_ri "Value added"
label var vaman_ri " "
label var expbalmannf "6 month expectations"
label var currbalmannf "Current situation"
label var year_m " "
twoway line expbalmannf currbalmannf year_m ||line vaman_ri year_m,yaxis(2)||, scheme(s1color) xtick(1975 1985 1995 2005) xlabel(1970 1980 1990 2000 2010) saving(ifomanuf,replace) ytitle(Balance) ysca(axis(1) r(-160 40)) ysca(axis(2) r(90 160)) title("A. Manufacturing and mining",position(11) size(medium)) ylabel(,axis(1) angle(0)) ylabel(70 80 90 100 110 120,axis(2) angle(0)) legend(off) text(-136 1985 "Value added") text(46 1990 "Current") text(33 2003 "Expect",size(small))
*ytitle("Value added, Q2 2005=100",axis(2))

graph export ifomanuf.eps, replace logo(off) mag(140)

gen ho=vacons_r if year==2005&quarter==2
egen hoho=max(ho)
gen vacons_ri=(vacons_r/hoho)*100
label var vacons_ri "Real value-added construction Q2 2005=100"
drop ho hoho

label var vacons_ri "Value added"
label var expbalbau "6 month expectations"
label var currbalbau "Current situation"
label var year_m " "
twoway line expbalbau currbalbau year_m ||line vacons_ri year_m,yaxis(2)||, scheme(s1color) xtick(1975 1985 1995 2005) xlabel(1970 1980 1990 2000 2010) saving(ifobau,replace) ysca(axis(1) r(-160 20)) ysca(axis(2) r(80 220)) ytitle("Value added",axis(2)) title(B. Construction,position(11) size(medium)) ylabel(-80 -60 -40 -20 0 20,axis(1) angle(0)) ylabel(,axis(2) angle(0)) legend(off) text(-152 1985 "Value added") text(-87 1985 "Current") text(3 2000 "Expect")
*ytitle(Balance: Positive-Negative) 

graph export ifobau.eps, replace logo(off) mag(140)

* einzelhandel - plot va for bigger sector
gen ho=vatrade_r if year==2005&quarter==2
egen hoho=max(ho)
gen vatrade_ri=(vatrade_r/hoho)*100
label var vatrade_ri "Real value-added construction Q2 2005=100"
drop ho hoho

*label var vatrade_ri "Value added"
label var vatrade_ri " "
label var expbaleinzel "6 month expectations"
label var currbaleinzel "Current situation"
label var year_m " "
twoway line expbaleinzel currbaleinzel year_m ||line vatrade_ri year_m,yaxis(2)||, scheme(s1color) xtick(1975 1985 1995 2005) xlabel(1970 1980 1990 2000 2010) saving(ifoeinzel,replace) ytitle(Balance) ysca(axis(1) r(-160 50)) ysca(axis(2) r(80 180)) title(C. Retail trade,position(11) size(medium)) ylabel(-60 -40 -20 0 20 40,axis(1) angle(0)) ylabel(,axis(2) angle(0)) legend(off) text(-133 1985 "Value added") text(40 1985.5 "Current") text(18 1998 "Expect")
*ytitle("Value added, Q2 2005=100",axis(2)) 

graph export ifoeinzel.eps, replace logo(off) mag(140)

* grosshandel - plot va for bigger sector (same as for einzel)
label var vatrade_ri "Value added"
label var expbalgross "6 month expectations"
label var currbalgross "Current situation"
label var year_m " "
twoway line expbalgross currbalgross year_m ||line vatrade_ri year_m,yaxis(2)||, scheme(s1color) xtick(1975 1985 1995 2005) xlabel(1970 1980 1990 2000 2010) saving(ifogross,replace) ysca(axis(1) r(-160 50)) ysca(axis(2) r(80 180)) ytitle("Value added",axis(2)) title(D. Wholesale trade,position(11) size(medium)) ylabel(-60 -40 -20 0 20 40,axis(1) angle(0)) ylabel(,axis(2) angle(0)) legend(off) text(-133 1985 "Value added") text(40 1986 "Current") text(12 1998 "Expect")
*ytitle(Balance: Positive-Negative) 

graph export ifogross.eps, replace logo(off) mag(140)

*grc1leg ifomanuf.gph ifobau.gph ifoeinzel.gph ifogross.gph,saving(ifobig,replace) scheme(s1color) imargin(small)

graph combine ifomanuf.gph ifobau.gph ifoeinzel.gph ifogross.gph,saving(ifobig,replace) scheme(s1color) imargin(zero)

graph export ifobig.eps, replace logo(off) mag(140)

* manufacturing for talk
twoway line expbalmannf currbalmannf year_m , scheme(s1color) xtick(1975 1985 1995 2005) xlabel(1970 1980 1990 2000 2010) saving(tifomanuf,replace) ytitle("% positive - % negative") ylabel(-50 -25 0 25 50,axis(1) angle(0)) legend(off) text(44 1990 "Current") text(31 2003 "Expect")

graph export tifomanuf.eps, replace logo(off) mag(130)
